import base64
import os
import random


def force_bytes(s):
    if isinstance(s, str):
        return s.encode("utf-8")
    return s


class Encoder:
    """
    Используем легаси-метод шифрования из руби-рассылятора
    Источник: https://github.yandex-team.ru/emm/mailer/blob/master/lib/yandex_crypt.rb
    """

    code = "L"

    def __init__(self):
        self.keys = list(self.load_keys())

    def load_keys(self):
        def path(filename):
            return os.path.join(os.path.abspath(os.path.dirname(__file__)), filename)

        for filename in [
            "key.txt",
        ]:
            with open(path(filename), "rb") as f:
                data = f.read().strip()
            yield data

    def encode(self, s, salt=None, keyno=0):
        """
        Шифруем строку s

        """

        strlen = len(s)
        if salt is None:
            salt = random.randint(0, 4096)
        stanza = self.keys[keyno][salt : salt + strlen]
        e = (
            base64.b64encode(bytes([x ^ y for x, y in zip(force_bytes(s), stanza)]))
            .strip()
            .decode("ascii")
        )
        code = "%s:%s:%s" % (e, salt, keyno)
        return base64.urlsafe_b64encode(code.encode("ascii")).decode("ascii")

    def decode(self, s):
        """
        Дешифруем строку s

        """

        el = base64.urlsafe_b64decode(force_bytes(s)).split(b":")
        xor = base64.b64decode(el[0])
        salt = int(el[1])
        keyno = int(el[2])
        stanza = self.keys[keyno][salt : salt + len(xor)]
        e = bytes([x ^ y for x, y in zip(xor, stanza)]).decode("ascii")
        return e


if __name__ == "__main__":
    import doctest

    doctest.testmod()
