import logging
import os.path
import chardet
from .xls import xls_to_csv


def reencode(data):
    """
    Иногда нужно определить кодировку и перекодировать csv-файл в utf-8

    :param data: собственно данные
    :param charset: конечная кодировка
    :return:
    """

    if isinstance(data, bytes):
        detected_encoding = chardet.detect(data[: 1024 * 10])["encoding"]
        try:
            return data.decode(detected_encoding)
        except UnicodeDecodeError as exc:
            # SENDER-215: иногда плохой символ может быть далеко от начала файла
            # в этом случае  возвращаем исходные данные в надежде, что это уже utf
            logging.warning("Error decode data from %s: %s", detected_encoding, exc)
            return data.decode("utf-8", errors="replace")

    return data


class UnsupportedFileFormat(Exception):
    pass


def csv_data_from_file(uploaded_file):
    """
    Читаем и готовим csv файл.
    Если это эксель, то конвертируем его в csv.

    :param uploaded_file:
    :raise UnsupportedFileFormat
    :return:
    """

    name, ext = os.path.splitext(uploaded_file.name)
    ext = ext.lower()
    if ext in (".xls", ".xlsx"):
        # Если это эксель-файл, то сконвертируем его в csv.
        # Это быстрое решение, в будущем лучше
        # убрать конвертацию и нативно поддерживать csv- и xls-файлы.
        content = xls_to_csv(uploaded_file.read())
    elif ext in (".csv", ".txt", ""):
        content = reencode(uploaded_file.read())
    else:
        raise UnsupportedFileFormat()

    return content
