from datetime import datetime, tzinfo
from typing import AnyStr, Union

import pytz


class Now:
    """Get timezone aware datetime object of current moment localized into given timezone"""

    MOSCOW_TZ = "Europe/Moscow"
    UTC_TZ = pytz.UTC

    def __init__(self, tz=UTC_TZ):
        # type: (Union[tzinfo, AnyStr]) -> None
        assert isinstance(tz, tzinfo) or isinstance(tz, str), "Bad tz argument type"
        if isinstance(tz, str):
            tz = pytz.timezone(tz)
        self.tz = tz  # type: tzinfo

    def __call__(self):
        # type: () -> datetime
        utc_naive = datetime.utcnow()
        utc_aware = pytz.UTC.localize(utc_naive)
        return utc_aware.astimezone(self.tz)


now_moscow = Now(tz=Now.MOSCOW_TZ)
now_for_tests = now_moscow
