"""
Скопировано из python-email-normalizer используем только нормализацию по домену яндекса
"""

from .base import BaseNormalizer
from .default import DefaultNormalizer
from .yandex import YandexNormalizer

__all__ = [
    "normalize",
]


NORMALIZERS = (YandexNormalizer,)


_domain_normalizers = {}


def _load_domains():
    for cls in NORMALIZERS:
        assert issubclass(cls, BaseNormalizer)
        for domain in cls.domains:
            if domain in _domain_normalizers:
                raise ValueError("Duplicated domain value %s for normalizer %s", domain, cls)

            _domain_normalizers[domain] = cls


def get_normalizer(domain):
    if domain in _domain_normalizers:
        return _domain_normalizers[domain]

    return DefaultNormalizer


_load_domains()
