import logging
from django.core.exceptions import ObjectDoesNotExist
from fan.models import Letter


def _abstract_getter(qs, fields, value, strict=True, **filters):
    last_exc = None
    for field in fields:
        try:
            spec = {}
            spec.update(filters)
            spec.update({field: value})
            return qs.get(**spec)
        except ObjectDoesNotExist as exc:
            last_exc = exc

    if strict:
        raise last_exc
    else:
        return None


def _model_getter(model, on_not_found=None, *a, **kw):
    try:
        return _abstract_getter(model.objects, *a, **kw)
    except ObjectDoesNotExist:
        if on_not_found:
            raise on_not_found()
        else:
            raise


def get_letter(id):
    logging.warning("unrestricted get_letter %s", id)
    return _model_getter(Letter, fields=["id"], value=id)
