import ipaddress


def get_client_ip(request):
    x_forwarded_for = request.META.get("HTTP_X_FORWARDED_FOR")
    if x_forwarded_for:
        return x_forwarded_for.split(",")[0]
    return request.META.get("REMOTE_ADDR")


def is_loopback(ip_address):
    """
    Returns True if ip_address is localhost.
    """
    return ipaddress.ip_address(ip_address).is_loopback


def is_loopback_request(request):
    """
    Returns True if client IP address is localhost.
    """
    ip = get_client_ip(request)
    return is_loopback(ip)
