from rest_framework.permissions import BasePermission


def additional_method_permissions(classes):
    def decorator(func):
        def decorated_func(self, *args, **kwargs):
            self.permission_classes = classes
            self.check_permissions(self.request)
            return func(self, *args, **kwargs)

        return decorated_func

    return decorator


def any_permission(*perm_classes, default_message="forbidden"):
    class Any(BasePermission):
        message = default_message

        def has_permission(*args, **kwargs):
            return any(p.has_permission(*args, **kwargs) for p in perm_classes)

    return Any
