from . import json
import socket

from fan.db.decorator import atomic_auto_retry
from fan.models import EditorialLog

from .request_data import get_user_agent, get_user_ip

host = socket.gethostname()


@atomic_auto_retry
def persistent_log(request=None, **kw):
    metadata = kw.get("metadata")
    if isinstance(metadata, (dict, list, tuple)):
        kw["metadata"] = json.dumps(metadata, ensure_ascii=False)

    if request:
        kw.update(
            {
                "user_ip": get_user_ip(request),
                "user_agent": get_user_agent(request),
                "user": request.user.username,
            }
        )
    o = EditorialLog(**kw)
    o.save()
    return o
