def get_pgaas_spec(
    name=None,
    host=None,
    port=6432,
    user="fan",
    password="",
    secure=True,
    read_write=True,
    connect_timeout=1,
):
    db_conf = {}
    db_conf.setdefault("CONN_MAX_AGE", 600)
    db_conf.update(
        {
            "ENGINE": "fan.db.postgres",
            "NAME": name,
            "USER": user,
            "PASSWORD": password,
            "HOST": host,
            "PORT": port,
        }
    )

    options = {}
    if secure:
        options["sslmode"] = "require"

    if read_write:
        options["target_session_attrs"] = "read-write"
    else:
        options["target_session_attrs"] = "any"

    options["connect_timeout"] = connect_timeout

    db_conf["OPTIONS"] = options
    return db_conf
