from random import randint
from time import time

from fan.utils.base_n import to_base36

EPOCH = 1304985600  # ~ 10.05.2011


def since_epoch(timestamp=None):
    timestamp = time() if timestamp is None else timestamp
    return int(timestamp - EPOCH) * 1000


def random_base36_slug(delim="-", prefix=None, timestamp=None):
    """
    Некрасивый, но универсальный слаг.
    :param delim:
    :param args:
    :return:
    """
    tokens = [to_base36(v) for v in [since_epoch(timestamp=timestamp), randint(100, 100000)]]
    if prefix:
        tokens.insert(0, prefix)
    return delim.join(tokens)


create_slug = random_base36_slug
