from fan.accounts.get import get_trusty


SO_RESERVED_HEADERS = {
    "x-sender-account",
    "x-sender-campaign-type",
    "x-sender-real-user-ip",
    "x-sender-has-ugc",
}


def get_so_headers(campaign, real_sender_ip=None, has_ugc=None):
    org_id = campaign.account.org_id
    so_headers = {
        # TODO check yandex_internal and pass account.name for Yandex services
        "X-Sender-Account": _get_so_header_prefix(campaign.account) + org_id,
        "X-Sender-Campaign-Type": campaign.type,
        "X-Sender-Real-User-IP": real_sender_ip,
        "X-Sender-Has-UGC": has_ugc,
    }
    return dict((k, str(v)) for k, v in list(so_headers.items()) if v is not None)


def _get_so_header_prefix(account):
    if get_trusty(account):
        return "B2B-Sender-"
    return "Free-Sender-"
