from io import BytesIO
from zipfile import ZipFile
from django.core.files.uploadedfile import InMemoryUploadedFile
from fan.message.letter import CONTENT_TYPE_ZIP


def create_zip_file(files, zip_name):
    letter_file = BytesIO()
    with ZipFile(letter_file, "w") as zip_file:
        for file_name, file_content in list(files.items()):
            zip_file.writestr(file_name, file_content.read())
    return InMemoryUploadedFile(
        file=letter_file,
        field_name=None,
        name=zip_name,
        content_type=CONTENT_TYPE_ZIP,
        size=len(letter_file.getvalue()),
        charset="utf-8",
    )
