#!/usr/bin/python3
# -*- coding: UTF-8 -*-

import datetime
import re
import requests

from yamail.pgaas import *
from bottle import route, run, request, redirect, template, response

get_traffic_sql = """ SELECT login, SUM(size)::NUMERIC::BIGINT AS size,  ARRAY_AGG(DISTINCT(fetches.ip)) AS ip_list, office  FROM fetches LEFT JOIN ip_office ON fetches.ip = ip_office.ip WHERE timestamp > '%%TODAY%%' AND login != 'hostname' GROUP BY (login, office) ORDER BY size DESC; """
get_update_info_sql = """ SELECT EXTRACT(EPOCH FROM current_timestamp - timestamp)::NUMERIC::INTEGER AS seconds, hostname FROM fetches WHERE login = 'hostname' AND timestamp > '%%TODAY%%'; """

template_file = '/usr/lib/fetches/main.tp'



def getData(sql, date=None):
    pg_today = datetime.datetime.now().strftime('%Y-%m-%d')
    if date is None:
        date = pg_today

    sql = re.sub('%%TODAY%%', date, sql)
    
    cursor, conn = getCursor(connect=True)
    cursor.execute(sql)
    return cursor.fetchall()

@route('/')
def root():


    fetches = getData(get_traffic_sql)
    update_data = getData(get_update_info_sql)
    return template(template_file, fetches=fetches, update_data=update_data)

@route('/api/traffic')
def api_traffic():
    print(json.dumps(getData(get_traffic_sql)))
    response.content_type = 'application/json; charset=utf-8'
    return json.dumps(getData(get_traffic_sql), ensure_ascii=False)


run(host='localhost', port=8080, debug=True)

