#!/usr/bin/python3
# -*- coding: utf-8 -*-

import datetime
from IPy import IP
import re
import requests
from yamail.pgaas import *

STAFF_OFFICE_API = 'https://staff.yandex-team.ru/whistlah/office_by_ip/'
YANDEX_NETS_URL = 'https://racktables.yandex-team.ru/export/networklist.php?report=allocs'

get_unknown_ips_sql = """ SELECT DISTINCT(ip) FROM fetches WHERE ip NOT IN (SELECT ip FROM ip_office) AND login != 'hostname'; """
add_office_ip_sql = """ INSERT INTO ip_office (ip, office) VALUES ('%%IP%%', '%%OFFICE%%');"""


cursor, conn = getCursor(connect=True)
cursor.execute(get_unknown_ips_sql)
ip_fetches = [ip['ip'] for ip in cursor.fetchall()]


def getYandexNets():
    yandex_nets = requests.get(YANDEX_NETS_URL).text.splitlines()
    return yandex_nets


def isYandexIP(ip):
    for network in YANDEX_NETS:
        if IP(ip) in IP(network):
            return True
    return False


def getOfficeByIP(ip, YANDEX_NETS):
    url = STAFF_OFFICE_API + ip
    office = requests.get(url).json()
    office_name = office.get('name')
    if office_name is None:
        office_name = 'external network'
        if isYandexIP(ip):
            office_name = 'production network'
    return office_name


def addOfficeIP(office, ip):
    cursor, conn = getCursor(connect=True)
    sql = re.sub('%%OFFICE%%', office, add_office_ip_sql)
    sql = re.sub('%%IP%%', ip, sql)
    cursor.execute(sql)
    conn.commit()

YANDEX_NETS = getYandexNets()
for ip in ip_fetches:
    office = getOfficeByIP(ip, YANDEX_NETS)
#    print(office)
    addOfficeIP(office, ip)
