#!/usr/bin/python3

import datetime
import re
import requests
from yamail.pgaas import *

update_fetches_sql = """ INSERT INTO fetches(hostname, timestamp, login, ip, size) VALUES %%VALUES%%; """
clear_host_sql = """ DELETE FROM fetches WHERE timestamp > '%%TODAY%%' AND hostname = '%%HOSTNAME%%'; """

def getHostsByGroup(group):
    CONDUCTOR_GROU_URL = 'https://c.yandex-team.ru/api/groups2hosts/'
    url = CONDUCTOR_GROU_URL + group + '?format=json'
    data = requests.get(url).json()
    return [host['fqdn'] for host in data]


imap_hosts = getHostsByGroup('mail_imapcorp')
pg_today = datetime.datetime.now().strftime('%Y-%m-%d')

fetch_data = {}
for imap_host in imap_hosts:
    print('Updating {}'.format(imap_host))

    url = 'http://' + imap_host + ':118/data.json'
    imap_host_data = requests.get(url).json()
    
    pg_now = datetime.datetime.now().strftime('%Y-%m-%d %H:%M:%S')

    sql_values = []
    for login, user_fetch in imap_host_data.items():
        if login != '':
            for ip, size in user_fetch.items():
                sql_values.append((imap_host, pg_now, login, ip, size))

    cursor, conn = getCursor(connect=True)
    # Удаляем данные по текущему хосту за сегодя:
    sql = re.sub('%%HOSTNAME%%', imap_host, clear_host_sql)
    sql = re.sub('%%TODAY%%', pg_today, sql)
    cursor.execute(sql)
    print(sql)

    # Вставляем данные по текущему хосту за сегодя:
    sql_values = str(sql_values)[1:][:-1]    
    sql = re.sub('%%VALUES%%', sql_values, update_fetches_sql)
    cursor.execute(sql)
    conn.commit()


