#pragma once

#include <yplatform/task_context.h>

#include <memory>

namespace furita {

inline auto SplitSessionId(const std::string& sessionId) {
    auto sep = sessionId.find('-');
    if (sep == std::string::npos) {
        return std::make_tuple(sessionId, std::string(""));
    }
    return std::make_tuple(sessionId.substr(0, sep), sessionId.substr(sep + 1));
}

class TContext : public yplatform::task_context {
public:
    TContext(const std::string& sessionId = "") 
        : yplatform::task_context(sessionId)
    {
        std::tie(ConnectionId, EnvelopeId) = SplitSessionId(sessionId);
    }

    const std::string& GetConnectionId() const {
        return ConnectionId;
    }

    const std::string& GetEnvelopeId() const {
        return EnvelopeId;
    }

    const std::string& GetSessionId() const {
        return uniq_id();
    }

    yplatform::task_context_ptr CreateTaskContext() const {
        return boost::make_shared<yplatform::task_context>(GetSessionId());
    }

private:
    std::string ConnectionId;
    std::string EnvelopeId;
};

using TContextPtr = std::shared_ptr<TContext>;

} // namespace furita
