#pragma once

#include "context.h"
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>

namespace log {

LOGDOG_DEFINE_ATTRIBUTE(std::string, method)
LOGDOG_DEFINE_ATTRIBUTE(std::string, uniq_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, connection_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, envelope_id)

constexpr static auto furita_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-furita-tskv-log"));

} // namespace log

inline auto makeLogger(const std::string& logId = "furita_log") {
    auto slog = std::make_shared<yplatform::log::source>(
            YGLOBAL_LOG_SERVICE, logId);
    return logdog::make_log(log::furita_formatter, slog);
}

inline auto makeContextLogger(const furita::TContextPtr ctx, const std::string& logId = "furita_log") {
    auto slog = std::make_shared<yplatform::log::source>(
            YGLOBAL_LOG_SERVICE, logId);
    return logdog::bind(makeLogger(logId),
        log::uniq_id=ctx->uniq_id(),
        log::connection_id=ctx->GetConnectionId(),
        log::envelope_id=ctx->GetEnvelopeId());
}

#define FURITA_LOG_DEBUG(ctx, ...) \
    LOGDOG_(makeContextLogger(ctx), debug, \
        __VA_ARGS__ \
    );
#define FURITA_LOG_NOTICE(ctx, ...) \
    LOGDOG_(makeContextLogger(ctx), notice, \
        __VA_ARGS__ \
    );
#define FURITA_LOG_ERROR(ctx, ...) \
    LOGDOG_(makeContextLogger(ctx), error, \
        __VA_ARGS__ \
    );
