#pragma once

#include <mail/furita/include/furita/core/types.h>

#include <mail/furita/include/furita/common/logger.h>


namespace furita {

inline auto getModuleLogger(const std::string& logId = "furita_log") {
    return makeLogger(logId);
}

inline auto getContextLogger(const SetDomainRulesParams& params) {
    return logdog::bind(
        getModuleLogger(),
        log::uniq_id=params.uniqId
    );
}

inline auto getContextLogger(const GetDomainRulesParams& params) {
    return logdog::bind(
        getModuleLogger(),
        log::uniq_id=params.uniqId
    );
}

} // namespace furita
