#pragma once

#include <boost/serialization/strong_typedef.hpp>

#include <string>


namespace furita {

BOOST_STRONG_TYPEDEF(std::int64_t, OrgId)
BOOST_STRONG_TYPEDEF(std::int32_t, Revision)
BOOST_STRONG_TYPEDEF(std::string, Rules)

using UniqId = std::string;


struct DomainRules {
    OrgId orgId;
    Revision revision;
    Rules rules;
};

struct SetDomainRulesParams {
    UniqId uniqId;

    OrgId orgId;
    Rules rules;
};

struct GetDomainRulesParams {
    UniqId uniqId;

    OrgId orgId;
};

} // namespace furita
