#pragma once

#include <yplatform/log.h>
#include <logdog/format/tskv.h>
#include <logdog/attributes/mail_attributes.h>
#include <logdog/logger.h>
#include <logdog/backend/yplatform_log.h>
#include <furita/common/logger.h>
#include <pgg/logging.h>
#include <pgg/logdog.h>

namespace furita {
namespace logging {

constexpr static auto furita_formatter = logdog::tskv::make_formatter(BOOST_HANA_STRING("furita-pgg-log"));

inline auto makeLog(const std::string& logId = "furita_log") {
    auto slog = std::make_shared<yplatform::log::source>(
            YGLOBAL_LOG_SERVICE, logId);
    return logdog::make_log(furita_formatter, slog);
}

inline auto makeContextLog(const TContextPtr ctx, const std::string& logId = "furita_log") {
    return logdog::bind(makeLog(logId), 
        logdog::attr::request_id=ctx->uniq_id(),
        log::uniq_id=ctx->uniq_id(),
        log::connection_id=ctx->GetConnectionId(),
        log::envelope_id=ctx->GetEnvelopeId());
}

template <typename Logger>
pgg::logging::LogPtr getPggLogger(Logger logger) {
    return pgg::logging::makeTypedLog(logdog::bind(logger, logdog::message="pgg"));
}

} // namespace logging
} // namespace furita
