#pragma once
#include <yplatform/module.h>
#include <yplatform/context_repository.h>
#include <yplatform/task_context.h>
#include <yplatform/future/future.hpp>
#include <pgg/service/uid_resolver.h>
#include <pgg/request_executor.h>
#include <sharpei_client/sharpei_client.h>
#include <furita/common/context.h>
#include <furita/common/rule.hpp>
#include <furita/common/rule_helper.hpp>

#include <boost/unordered_map.hpp>

namespace furita {
namespace pq {

using yplatform::future::future;
using yplatform::future::promise;

using UserConnInfoResult = boost::variant<std::string, mail_errors::error_code>;
using RulesResult = boost::variant<rules::rule_list_ptr, mail_errors::error_code>;

class pq: public yplatform::module {
public:
    virtual future<boost::unordered_map<uint64_t, RulesResult>>
    get_rules_multiuser(
        const TContextPtr& ctx,
        const std::vector<uint64_t>& uids,
        sharpei::client::Mode mode = sharpei::client::Mode::WriteOnly) = 0;

    virtual future<rules::rule_list_ptr> get_rule(pgg::RequestExecutor& executor,
                                                  const uint64_t& uid, const uint64_t& rule_id) = 0;

    virtual future<rules::rule_list_ptr> get_all_rules(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) = 0;

    virtual future<rules::rule_list_ptr> get_rules_by_type(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const rules_helpers::RuleType& type) = 0;

    virtual future<void> remove_rules(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::vector<uint64_t>& ids) = 0;

    virtual future<void> enable_rule(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& id, bool enabled) = 0;

    virtual future<rules::condition_list_ptr> get_rule_conditions(
        pgg::RequestExecutor& executor,
        const uint64_t& uid, const uint64_t& rule_id) = 0;

    virtual future<rules::condition_list_ptr> get_all_conditions(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) = 0;

    virtual future<rules::action_list_ptr> get_rule_actions(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& rule_id) = 0;

    virtual future<rules::action_list_ptr> get_all_actions(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) = 0;

    virtual future<rules::action_list_ptr> get_action(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& action_id) = 0;

    virtual future<bool> order_rule(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::vector<uint64_t>& ids) = 0;

    virtual future<void> verify_rule(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& id) = 0;

    virtual future<void> edit_rule(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const rules::rule_ptr& rule, const boost::optional<uint64_t>& old_id, bool last) = 0;

    virtual future<std::map<uint64_t, std::pair<std::string, std::string>>> get_not_verified_parameters(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const uint64_t& id) = 0;

    virtual future<uint64_t> get_new_rule_id(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) = 0;

    virtual future<rules::blacklist_ptr> get_all_lists(
        pgg::RequestExecutor& executor,
        const uint64_t& uid) = 0;

    virtual future<rules::blacklist_ptr> get_list_by_type(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::string& type) = 0;

    virtual future<void> remove_from_list(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::vector<std::string>& emails,
        const std::string& type) = 0;

    virtual future<void> add_to_list(
        pgg::RequestExecutor& executor,
        const uint64_t& uid,
        const std::string& email,
        const std::string& type) = 0;

    virtual pgg::SharpeiParams create_sharpei_params(const TContextPtr& ctx) = 0;

    virtual pgg::RequestExecutor create_request_executor(const TContextPtr& ctx,
                                                         const uint64_t& id,
                                                         const pgg::UidResolverFactoryPtr& resolverFactory,
                                                         sharpei::client::Mode mode = sharpei::client::Mode::WriteOnly) = 0;
};

}
}
