#pragma once

#include <ymod_httpclient/call.h>
#include <yplatform/module.h>
#include <yplatform/task_context.h>
#include <yplatform/future/future.hpp>
#include <furita/common/context.h>
#include <furita/common/rule.hpp>
#include <furita/common/rule_helper.hpp>

#include <sharpei_client/sharpei_client.h>

namespace furita {

namespace processor {
using yplatform::future::promise;
using yplatform::future::future;

enum status_result {
    SUCCESS, FAIL
};

class processor : public yplatform::module
{
public:
    using SharpeiMode = sharpei::client::Mode;

    virtual future<std::vector<std::string>> preview(
        const TContextPtr& context,
        const uint64_t& uid,
        const uint64_t& id,
        unsigned int length,
        unsigned int offset,
        const std::string& remote_ip,
        const std::string& tvm,
        const ymod_httpclient::headers_dict& headers) = 0;

    virtual future<std::vector<std::string>> preview(
        const TContextPtr& context,
        const uint64_t& uid,
        const rules::rule_ptr& rule,
        unsigned int length,
        unsigned int offset,
        const std::string& remote_ip,
        const std::string& tvm,
        const ymod_httpclient::headers_dict& headers) = 0;

    virtual future<void> apply(
        const TContextPtr& context,
        const uint64_t& uid,
        const uint64_t& id,
        bool master,
        const std::string& remote_ip,
        const std::string& tvm,
        const ymod_httpclient::headers_dict& headers) = 0;

    virtual future<std::pair<status_result, boost::optional<uint64_t>>> rule_edit(
        const TContextPtr& ctx,
        const uint64_t& uid,
        const boost::optional<uint64_t>& id,
        const rules::rule_ptr& rule,
        bool last,
        const std::string& from,
        const std::string& lang,
        const std::string& confirm_domain,
        const std::string& auth_domain) = 0;
};

}   // namespace processor
}   // namespace furita
