#!/usr/bin/env python

import logging
import argparse
import json
import random
import sys

cfg = [
    {'name': 'blackwhitelist', 'weight': 55, 'params': None},
    {'name': 'multi_list' , 'weight':39, 'params':{0:25,1:70,5:4,20:1}},
    {'name': 'list.json', 'weight': 4, 'params': None}
]

def read_users(users_file):
    users = []
    with open(users_file, 'r') as f:
        for line in f.readlines():
            email, uid, white_black_count, rules_count = line.strip().split(',')
            users.append((int(uid), int(white_black_count), int(rules_count)))
    return users

def gen_ammo(handler, users, params=None):
    uid, white_black_count, rules_count = random.choice(users)
    tag = ''
    if handler == 'blackwhitelist':
        uri = '/api/blackwhitelist?uid=%d' % uid
        tag = '%d_wb' % white_black_count
    elif handler == 'list.json':
        uri = '/api/list.json?detailed=1&type=user&uid=%d&db=pg&user=%d&connection_id=LOAD-%05d' % (uid, uid, random.randint(0,10000))
        tag = '%d_rules' % rules_count
    elif handler == 'multi_list':
        counts = []
        for c in params:
            counts += [c] * params[c]
        count = random.choice(counts)
        uri, tag = gen_multi(users, count)
    return '%s %s_%s\n' % (uri, handler, tag)

def gen_multi(users, count):
    if count > len(users):
        raise ValueError("Not enough uids for list %d", size)
    uids = [str(i[0]) for i in random.sample(users, count)]
    uids_str = ','.join(uids)
    return ('/api/multi_list/?uids=%s' % uids_str,  '%d_users' % count)
        
def do_ammo(out, users, cfg, ammo_count):
    weighted = []
    for handler in cfg:
        weighted += [(handler['name'], handler['params'])] * handler['weight']
    with open(out, 'wb') as f:
        for i in range(ammo_count):
            handler, params = random.choice(weighted)
            ammo = gen_ammo(handler, users, params=params)
            f.write(ammo)
    

def main():
    parser = argparse.ArgumentParser(description='Generate ammo for furita')
    parser.add_argument('-d', '--debug', action='store_true')
    parser.add_argument('--users-file', dest='users_file', help='Path to furita users csv')
    parser.add_argument('--ammo-count', dest='ammo_count', type=int, default=10000)
    parser.add_argument('--out', help='Path for result ammo file', default=sys.stdout)
    args = parser.parse_args()

    users = read_users(args.users_file)
    do_ammo(args.out, users, cfg, args.ammo_count)


if __name__ == '__main__':
    log = logging.getLogger('furita_ammo_gen')
    log.setLevel(logging.INFO)
    ch = logging.StreamHandler()
    formatter = logging.Formatter('%(asctime)s - %(filename)s:%(lineno)d(%(funcName)s) - %(levelname)s - %(message)s')
    ch.setFormatter(formatter)
    log.addHandler(ch)
    main()
