#!/bin/bash
#
# Provides: furita_4xx

PROD_LIMIT=1
CORP_LIMIT=1

errors_4xx=$(timetail -n60 /var/log/furita/access.tskv | python /etc/monrun/furita/percent_match.py '\tstatus_code=4[0-9]{2}')
if [ "$(qloud_var is_corp)" == "True" ]; then
    limit=$CORP_LIMIT
else
    limit=$PROD_LIMIT
fi

if [ $errors_4xx -gt $limit ]; then
    echo "PASSIVE-CHECK:furita_4xx;2;4xx: $errors_4xx"
else
    echo "PASSIVE-CHECK:furita_4xx;0;4xx: $errors_4xx"
fi

