#!/bin/bash
#
# Provides: furita_5xx

PROD_LIMIT=1
CORP_LIMIT=1

errors_5xx=$(timetail -n60 /var/log/furita/access.tskv | python /etc/monrun/furita/percent_match.py '\tstatus_code=5[0-9]{2}')
if [ "$(qloud_var is_corp)" == "True" ]; then
    limit=$CORP_LIMIT
else
    limit=$PROD_LIMIT
fi

if [ $errors_5xx -gt $limit ]; then
    echo "PASSIVE-CHECK:furita_5xx;2;5xx: $errors_5xx"
else
    echo "PASSIVE-CHECK:furita_5xx;0;5xx: $errors_5xx"
fi

