#!/bin/bash

source /usr/lib/qloud-mail-common.sh

groupadd -r furita
useradd -r -s /bin/false -g furita furita

mkdir -p /var/run/furita
chown -R furita:furita /var/run/furita

qloud_link /var/log/furita furita:furita
qloud_link /var/log/nginx
qloud_link /var/log/yamail-logs

mkdir -p /var/log/nginx/furita

chmod 755 /etc/yamail/
chown furita:furita /etc/yamail/.pgpass
chown furita:furita /etc/yamail/pgca.pem
chown furita:furita /etc/furita/tvm_secret

ln -svf /etc/furita/$ENVIRONMENT_TYPE_FULL.yml /etc/furita/config.yml

ln -sf /etc/furita/push-client/push-client-furita-log.yaml-${MAIL_TYPE} /etc/push-client/push-client-furita-log.yaml

ln -sf /etc/nginx/sites-available/service.conf-${ENVIRONMENT_TYPE_FULL} /etc/nginx/sites-enabled/service.conf
ln -sf /etc/nginx/sites-available/service.include /etc/nginx/sites-enabled/service.include
ln -sf /etc/nginx/sites-available/log_by_lua.include /etc/nginx/sites-enabled/log_by_lua.include
ln -sf /etc/nginx/sites-available/unistat.conf /etc/nginx/sites-enabled/unistat.conf

app=furita

# Trunkate ssl config if there is no certificate:
if [ ! -f /etc/nginx/ssl/furita.pem ];then
    :> /etc/nginx/listen_ssl
fi

exec "$@"
