#!/usr/bin/python

import subprocess, socket, urllib, time, sys
from yamail import qloud

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
cgroup = "mail_furita_corp" if qloud.environ.is_corp  else 'mail_furita'
current_ts = int(time.time())

cmd = 'timetail -n60 -r (\d+\/\w+\/\d+:\d+:\d+:\d+)  /var/log/furita/access.log'
p = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=open('/dev/null'))
all_records = p.communicate()[0].splitlines()

codes = ['2xx','3xx','4xx','5xx']
timings = ['20ms','100ms','300ms','1s','over1s']

d = {}
d['code'] = {}
d['time'] = {}

for c in codes:
    d['code'][c] = 0
for t in timings:
    d['time'][t] = 0

for record in all_records:
    if " /ping" not in record:
        try:
            code = int(record.split(' ')[9])
        except:
            code = 0
        if 200 <= code < 300:
            d['code']['2xx'] += 1
        elif 300 <= code < 400:
            d['code']['3xx'] += 1
        elif 400 <= code < 500:
            d['code']['4xx'] += 1
        elif code >= 500:
            d['code']['5xx'] += 1

        try:
            time = int(float(record.split(' ')[-1]) * 1000)
        except:
            time = 0
        if time <= 20:
            d['time']['20ms'] += 1
        elif 20 < time <= 100:
            d['time']['100ms'] += 1
        elif 100 < time <= 300:
            d['time']['300ms'] += 1
        elif 300 < time <= 1000:
            d['time']['1s'] += 1
        elif time > 1000:
            d['time']['over1s'] += 1

for k,v in d.items():
    for k1,v1 in v.items():
        print("mail.%s.%s.furita.access.%s.%s %d %d" % (cgroup, hostname_s, k, k1, v1, current_ts))

