#!/usr/bin/python

import sys, time, subprocess, socket
from yamail import qloud

me = sys.argv[0].split('/')[-1].split('.')[0]
cgroup = "mail_furita_corp" if qloud.environ.is_corp  else 'mail_furita'
current_ts = int(time.time())
hostname_s = socket.gethostname().replace('.', '_')

cmd = "timetail -n 60 -r ([0-9][0-9]:[0-9][0-9]:[0-9][0-9]) /var/log/furita/furita.log"
p = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=open('/dev/null'))
all_records = p.communicate()[0].splitlines()

errors = ['Operation canceled','ymod_pq error','sharpei error','no databases found alive',
            'Failed to get conninfo','Failed to get rules','Failed to find action',
            'Failed to get blacklist','Parameter already verified',
            'Failed to apply rule actions','Failed to get conditions','Failed to get data source']

d = {}
d['error'] = {}
for e in errors:
    d['error'][e.lower().replace(' ', '_')] = 0

for record in all_records:
    for e in errors:
        if e in record:
            d['error'][e.lower().replace(' ', '_')] += 1

for k,v in d.items():
    for k1,v1 in v.items():
        print("mail.%s.%s.furita.%s.%s %d %d" % (cgroup, hostname_s, k, k1, v1, current_ts))
