#!/usr/bin/python

import subprocess
import socket
import time
import sys
import re
from yamail import qloud

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
cgroup = "mail_furita_corp" if qloud.environ.is_corp  else 'mail_furita'
current_ts = int(time.time())

cmd = 'pa -t 60 /var/log/furita/profiler.log'
p = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=open('/dev/null'))
all_records = p.communicate()[0].splitlines()

timings = ['20ms','100ms','300ms','1s','over1s']
services = ['postgresql','oracle']
requests = ["all"]

# time service address request id time
str_re = re.compile("([0-9:]+)\s+([a-zA-Z0-9_\-]+)\s+([a-zA-Z0-9?_:\/\.\-]*)\s+([a-zA-Z0-9?&_:=\/\.\-]+)\s+([a-zA-Z0-9]+)\s+([0-9\.]+)")

d = {}
for s in services:
    d[s] = {}
    d[s]['time'] = {}
    d[s]['rpm'] = {}
    d[s]['rpm']['total'] = 0
    for t in timings:
        d[s]['time'][t] = 0

for record in all_records:
    m = str_re.match(record)
    if m:
        for s in services:
            service = m.groups()[1]

            if s in service:
                d[s]['rpm']['total'] += 1
                try:
                    time = int(float(record.split(' ')[-1]) * 1000)
                except:
                    time = 0
                if time <= 20:
                    d[s]['time']['20ms'] += 1
                elif 20 < time <= 100:
                    d[s]['time']['100ms'] += 1
                elif 100 < time <= 300:
                    d[s]['time']['300ms'] += 1
                elif 300 < time <= 1000:
                    d[s]['time']['1s'] += 1
                elif time > 1000:
                    d[s]['time']['over1s'] += 1
                    break


for k, v in d.items():
    for k1, v1 in v.items():
        for k2, v2 in v1.items():
                print("mail.%s.%s.furita.pa.%s.%s.%s %d %d" % (cgroup, hostname_s, k, k1, k2, v2, current_ts))
