#include "util.h"
#include "json_writer.h"
#include "buffer_chunk.h"
#include "apply_handler.h"

#include <furita/common/context.h>
#include <furita/common/http_headers.h>
#include <furita/common/logger.h>

#include <yplatform/find.h>
#include <src/processor/http_client.hpp>

namespace furita {
namespace api {

void ApplyHandler::execute(HttpStreamPtr stream, TContextPtr ctx) const {
    uint64_t uid, id;
    std::string remote_ip, tvm;
    bool master;
    ymod_httpclient::headers_dict headers;
    try {
        const auto &params = stream->request()->url.params;
        uid = parameterValue<uint64_t>(params, "uid");
        id = parameterValue<uint64_t>(params, "id");
        master = parameterValue(params, "master", false);
        remote_ip = parameterValue(params, "remote_ip", std::string());
        auto& request_headers = stream->request()->headers;
        tvm = request_headers[HttpHeaderNames::ticket];
        if (auto it = request_headers.find(HttpHeaderNames::tvmUserTicket); it != request_headers.end()) {
            headers.emplace(HttpHeaderNames::tvmUserTicket, it->second); // we've already checked it
        }
    } catch (const std::exception &e) {
        FURITA_LOG_ERROR(ctx, logdog::exception=e, logdog::message="apply operation finished: status=error")
        return handleFail(stream, "No enough parameters");
    }

    try {
        auto processor = yplatform::find<processor::processor>("furita_processor");
        processor->apply(ctx, uid, id, master, remote_ip, tvm, headers);

        stream->set_code(ymod_webserver::codes::ok);

        boost::shared_ptr<json_buffer_chunk> buffer(new json_buffer_chunk);

        json_writer &writer = buffer->m_writer;
        writer.begin_object().add_member("session", stream->ctx()->uniq_id());
        writer.end_object().close();

        stream->set_content_type("application", "json");
        stream->result_stream(writer.size())->send(buffer);
    } catch (const std::exception &e) {
        FURITA_LOG_ERROR(ctx, logdog::exception=e, logdog::message="apply operation finished: status=error")
        return _handleError(stream, std::string("Internal server error"));
    }
}

}   // namespace api
}   // namespace furita
