#pragma once

#include <furita/processor/processor.hpp>
#include "common_handler.h"
#include <furita/pq/pq.hpp>

namespace furita {
namespace api {

class BWAddHandler: public CommonHandler {
public:
    explicit BWAddHandler(rules::ListType type)
        : CommonHandler()
        , type(type)
    {}

    void execute(HttpStreamPtr stream, TContextPtr ctx) const override;

private:
    struct Arguments;
    using ArgumentsPtr = std::shared_ptr<struct Arguments>;

    void handleList(ArgumentsPtr args, pgg::RequestExecutor& executor, furita::pq::future<rules::blacklist_ptr> fbl, TContextPtr ctx) const;
    void handleResult(ArgumentsPtr args, furita::pq::future<void> fv, TContextPtr ctx) const;

    rules::ListType type;
};

}   // namespace api
}   // namespace furita
