#pragma once

#include <furita/pq/pq.hpp>
#include <furita/processor/processor.hpp>
#include "common_handler.h"

namespace furita {
namespace api {

class BWHandler: public CommonHandler
{
public:
    explicit BWHandler(rules::ListType type)
        : CommonHandler()
        , type(type)
    {}

    void execute(HttpStreamPtr stream, TContextPtr ctx) const override;

private:
    struct Arguments;
    using ArgumentsPtr = std::shared_ptr<struct Arguments>;

    void handleResult(ArgumentsPtr args, furita::pq::future<rules::blacklist_ptr> result, TContextPtr ctx) const;

    rules::ListType type;
};

}   // namespace furita
}   // namespace api
