#pragma once

#include <furita/processor/processor.hpp>
#include <furita/pq/pq.hpp>
#include "common_handler.h"

namespace furita {
namespace api {

class BWRemoveHandler: public CommonHandler
{
public:
    explicit BWRemoveHandler(rules::ListType type)
        : CommonHandler()
        , type(type)
    {}

    void execute(HttpStreamPtr stream, TContextPtr ctx) const override;

private:
    struct Arguments;
    using ArgumentsPtr = std::shared_ptr<struct Arguments>;

    void handleResult(ArgumentsPtr args, furita::pq::future<void> result, TContextPtr ctx) const;

    rules::ListType type;
};

}   // namespace api
}   // namespace furita
