#include "buffer_chunk.h"
#include "common_handler.h"

namespace furita {
namespace api {

void CommonHandler::_handleError(
        HttpStreamPtr stream,
        const std::string &message,
        const ymod_webserver::codes::code &code) const
{
    boost::shared_ptr<json_buffer_chunk> buffer(new json_buffer_chunk);

    json_writer &writer = buffer->m_writer;
    writer.begin_object();
    writer.add_member("session", stream->ctx()->uniq_id());
    writer.add_member("status", "error");
    writer.add_member("report", message);
    writer.end_object().close();

    stream->set_code(code);
    stream->set_content_type("application", "json");
    stream->result_stream(writer.size())->send(buffer);
}

void CommonHandler::handleFail(HttpStreamPtr stream, const std::string &message) const
{
    _handleError(stream, message, ymod_webserver::codes::bad_request);
}

const std::string& CommonHandler::parameterValue(
    const ParamsMap& parameters,
    const std::string &name,
    const std::string &def) const
{
    auto iter = parameters.find(name);
    return iter != parameters.end() ? iter->second : def;
}

const std::string& CommonHandler::parameterValue(
    const ParamsMap& parameters,
    const std::string &name) const
{
    auto iter = parameters.find(name);
    if (iter == parameters.end()) {
        throw std::runtime_error("parameter not found: " + name);
    }
    return iter->second;
}

}   // namespace api
}   // namespac furita
