#pragma once

#include <furita/common/context.h>
#include <furita/common/logger.h>

#include <ymod_webserver/response.h>

#include <memory>

namespace furita {
namespace api {
using yplatform::future::promise;
using yplatform::future::future;
using HttpStreamPtr = ymod_webserver::http::stream_ptr;

class CommonHandler {
public:
    using ParamsMap = ymod_webserver::param_map_t;

    CommonHandler() = default;
    virtual ~CommonHandler() {}

    virtual void execute(HttpStreamPtr stream, TContextPtr ctx) const = 0;

protected:
    void _handleError(
            HttpStreamPtr stream,
            const std::string &message,
            const ymod_webserver::codes::code &code = ymod_webserver::codes::internal_server_error) const;
    void handleFail(HttpStreamPtr stream, const std::string &message) const;

    template <typename Future>
    void handleError(HttpStreamPtr stream, const char *name, Future r) const {
        TContextPtr ctx = std::make_shared<TContext>((stream->ctx())->uniq_id());
        const std::string desc = exception_description(r);
        using namespace std::string_literals;
        FURITA_LOG_ERROR(ctx, logdog::message=name + " operation finished: status=error, report='"s + desc + "'")
        _handleError(stream, desc);
    }

    template <class T>
    T parameterValue(const ParamsMap& parameters, const std::string &name) const {
        auto i = parameters.find(name);
        if (i == parameters.end()) {
            throw std::runtime_error("parameter not found: " + name);
        }
        return boost::lexical_cast<T>(i->second);
    }

    template <class T>
    T parameterValue(const ParamsMap& parameters, const std::string &name, T def) const {
        try {
            return parameterValue<T>(parameters, name);
        } catch (...) {
            return def;
        }
    }

    const std::string& parameterValue(
        const ParamsMap& parameters,
        const std::string &name,
        const std::string &def) const;

    const std::string& parameterValue(const ParamsMap& parameters, const std::string &name) const;
};

}   // namespace api
}   // namespace furita
