#include "handler_impl.h"

#include <mail/furita/src/api/common_handler.h>

namespace furita::domain_rules_get {

THandlerImpl::THandlerImpl(
    RepositoryPtr repository,
    boost::asio::io_context& ioContext
)
    : Repository(std::move(repository))
    , IoContext(ioContext) {}

void THandlerImpl::Run(TContextPtr ctx, TRequest req, TCallback cb) {
    GetDomainRulesParams params {
        .uniqId = UniqId{ctx->uniq_id()},
        .orgId = OrgId{req.OrgId}
    };

    Repository->getDomainRules(std::move(params),
        [ctx, cb = std::move(cb), &ioCtx = IoContext](auto ec, auto arg) {
            THandlerImpl::HandleGetDomainRules(
                std::move(ctx),
                std::move(ec),
                ioCtx,
                std::move(arg),
                std::move(cb)
            );
    });
}

void THandlerImpl::HandleGetDomainRules(TContextPtr ctx,
    mail_errors::error_code ec,
    boost::asio::io_context& ioContext,
    boost::optional<DomainRules> result,
    TCallback cb
) {
    if (ec) {
        FURITA_LOG_ERROR(ctx, logdog::error_code=ec, logdog::message="Error occurred");
        return boost::asio::post(ioContext, std::bind(std::move(cb), ec.base(), TResponse{}));
    }
    if (!result) {
        FURITA_LOG_ERROR(ctx, logdog::message="Empty result for rules");
        return boost::asio::post(ioContext, std::bind(std::move(cb), boost::system::error_code{}, TResponse{}));
    }

    boost::asio::post(ioContext, 
        std::bind(std::move(cb),
            boost::system::error_code{}, 
            TResponse{.Rules = result->rules, .Revision = result->revision}
        )
    );
}

}
