#pragma once

#include "interface.h"
#include "types.h"
#include "utils.h"

#include <furita/common/context.h>
#include <mail/furita/ymod_db/include/repository.h>

#include <boost/asio/io_context.hpp>
#include <boost/system/error_code.hpp>

#include <optional>

namespace furita::domain_rules_get {

class THandlerImpl : public IHandler {
public:
    THandlerImpl(
        RepositoryPtr repository,
        boost::asio::io_context& ioContext);

    void Run(TContextPtr ctx, TRequest req, TCallback cb) override;

private:
    static void HandleGetDomainRules(TContextPtr ctx, 
        mail_errors::error_code ec, 
        boost::asio::io_context& ioContext,
        boost::optional<DomainRules> result,
        TCallback cb);

private:
    RepositoryPtr Repository;
    boost::asio::io_context& IoContext;
};

}
