#pragma once

#include "types.h"

#include <furita/common/context.h>

#include <boost/system/error_code.hpp>

#include <memory>
#include <functional>

namespace furita::domain_rules_set {

using TCallback = std::function<void(boost::system::error_code ec, TResponse resp)>;

struct IHandler {
    virtual ~IHandler() = default;

    virtual void Run(TContextPtr ctx, TRequest req, TCallback cb) = 0;
};

using THandlerPtr = std::shared_ptr<IHandler>;

}
