#pragma once

#include <furita/common/context.h>

#include <mail/furita/include/furita/core/types.h>
#include <mail/furita/ymod_db/include/repository.h>

#include <yplatform/json.h>

#include <string>
#include <vector>
#include <optional>
#include <cstdint>

namespace furita::domain_rules_set {

struct TAction {
    std::string Action;
    std::optional<std::string> Email;
};

enum class EDirectionScope {
    INBOUND,
    OUTBOUND
};

struct TScope {
    EDirectionScope Direction;
};

struct TRule {
    std::optional<bool> Terminal;
    TScope Scope;
    yplatform::json_value Condition;
    std::string ConditionQuery;
    std::vector<TAction> Actions;
};

struct TRequest {
    std::int64_t OrgId;
    std::vector<TRule> Rules;
};

struct TResponse {
    std::string Message;
};

struct TRulesSpec {
    std::vector<TRule> Rules;
};

}
