#pragma once

#include "types.h"

#include <yplatform/json.h>

#include <string>

namespace furita::domain_rules_set::utils {

yplatform::json_value FromJson(const std::string& json);

void ParseTerminal(const yplatform::json_value& val, TRule& rule);

void ParseScope(const yplatform::json_value& val, TRule& rule);

void ParseCondition(const yplatform::json_value& val, TRule& rule);

void ParseActions(const yplatform::json_value& val, TRule& rule);

TRule ParseRule(const yplatform::json_value& val);

std::vector<TRule> ParseRules(const yplatform::json_value& val);

TRulesSpec ParseRulesSpec(const std::string& body);

yplatform::json_value RuleToJson(const TRule& rule);

yplatform::json_value RulesToJson(const std::vector<TRule>& rules);

}
