#pragma once

#include <furita/processor/processor.hpp>
#include <src/processor/impl.h>
#include <src/processor/so_check_filter.h>
#include "common_handler.h"

namespace furita {
namespace api {

class EditHandler: public CommonHandler
{
public:
    void execute(HttpStreamPtr stream, TContextPtr ctx) const override;

private:
    struct TRuleParams {
        uint64_t uid;
        boost::optional<uint64_t> id;
        rules::rule_ptr rule;
        bool last;
        std::string from;
        std::string lang;
        std::string confirm_domain;
        std::string auth_domain;
    };

    void handleSoCheckResult(HttpStreamPtr stream, future<processor::so_check::EResult> future_so_check_result,
                             bool dry_run, const TRuleParams& rule_params, TContextPtr ctx) const;

    void ruleEdit(HttpStreamPtr stream, const TRuleParams& rule_params, TContextPtr ctx) const;

    void handleResult(HttpStreamPtr stream, future<std::pair<processor::status_result, boost::optional<uint64_t>>> result, TContextPtr ctx) const;
};

}   // namespace api
}   // namespace furita
