#pragma once
#include "common_handler.h"

#include <furita/pq/pq.hpp>
#include <furita/processor/processor.hpp>

#include <boost/unordered_map.hpp>

namespace furita {
namespace api {
class ListBatchHandler: public CommonHandler, public boost::enable_shared_from_this<ListBatchHandler>{
public:
    void execute(HttpStreamPtr stream, TContextPtr ctx) const override;

    struct Data;
    using DataPtr = std::shared_ptr<struct Data>;

private:
    void HandleResult(const DataPtr args, future<boost::unordered_map<uint64_t, furita::pq::RulesResult>> f, TContextPtr ctx) const;
    std::string getQueryString(const rules::rule_ptr& rule, const DataPtr args, const std::string& uid, TContextPtr ctx) const;
};
}
}
