#pragma once

#include <furita/processor/processor.hpp>
#include <pgg/request_executor.h>
#include "common_handler.h"

namespace furita {
namespace api {

class ListHandler: public CommonHandler
{
public:
    void execute(HttpStreamPtr stream, TContextPtr ctx) const override;

private:
    struct Data;
    using DataPtr = std::shared_ptr<struct Data>;

    void handleRules(DataPtr args, pgg::RequestExecutor& executor,
                     future<rules::rule_list_ptr> f_rules, TContextPtr ctx) const;
    void handleActions(DataPtr args, pgg::RequestExecutor& executor,
                       future<rules::action_list_ptr> f_actions, TContextPtr ctx) const;
    void handleConditions(DataPtr args, future<rules::condition_list_ptr> r, TContextPtr ctx) const;
    void handleResult(const DataPtr& args, TContextPtr ctx) const;

    std::string getQueryString(const rules::rule_ptr& rule, const DataPtr& args, TContextPtr ctx) const;
};

}   // namespace api
}   // namespace furita
