#include <string>
#include <set>
#include <furita/common/rule_helper.hpp>

namespace furita {
namespace rules_helpers {

bool acceptableForExistsCondition(const std::string& field) {
    static const std::set<std::string> inacceptableFields = {
        "all", "nospam", "clearspam", "spam", "subscribes", "list", "att", "subject",
        "ya_syslabel", "ya_systype", "filename", "body", "tocc", "to", "from", "cc", "type"
    };

    return (inacceptableFields.find(field) == inacceptableFields.end());
}

std::string findFieldType(const std::string &field) {
    static const std::set<std::string> flagFields = {
        "all", "nospam", "clearspam", "spam", "subscribes", "list", "att", "ya_syslabel", "ya_systype"
    };

    if (flagFields.find(field) != flagFields.end()) {
        return "flag";
    } else if (field == "body") {
        return "body";
    } else if (field == "filename") {
        return "attach";
    } else if (field == "type") {
        return "type";
    } else {
        return "header";
    }
}

}   // namespace rules_helpers
}   // namespace furita
