#pragma once

#include <mail/ymod_tvm/include/ymod_tvm/tvm.h>
#include <mail/ymod_webserver/include/ymod_webserver/response.h>
#include <yplatform/exception.h>

namespace furita {

template <typename F>
static std::string exception_description(F& result)
{
    if (!result.has_exception())
        return "no exceptions";
    try
    {
        result.get();
    }
    catch (yplatform::exception &e)
    {
        return e.public_message();
    }
    catch (std::exception &e)
    {
        return e.what();
    }
    catch (...)
    {
    }
    return "unknown";
}

bool check_address(const std::string &address);

ymod_tvm::tvm2::blackbox_env ConvertBBEnvironmentToEnum(const std::string& env);

using TErrorMsg = std::string;

std::optional<TErrorMsg> CheckTvmTickets(ymod_webserver::http::stream_ptr stream, ymod_tvm::tvm2::blackbox_env bbEnv);

namespace api {

using HttpStreamPtr = ymod_webserver::http::stream_ptr;

void ResponseMessage(HttpStreamPtr stream, ymod_webserver::codes::code code, std::string msg);

}

}
