#pragma once

#include <furita/processor/processor.hpp>
#include "common_handler.h"

namespace furita {
namespace api {

class VerifyHandler: public CommonHandler {
public:
    void execute(HttpStreamPtr stream, TContextPtr ctx) const override;

private:
    struct Data;
    using DataPtr = std::shared_ptr<struct Data>;

    void getActions(DataPtr arg) const;
    void handleAction(DataPtr arg, pgg::RequestExecutor& executor, future<rules::action_list_ptr> result, TContextPtr ctx) const;
    void handleVerify(DataPtr arg, future<void> result, TContextPtr ctx) const;
    void handleResult(const DataPtr& arg, TContextPtr ctx) const;
};

}   // namespace api
}   // namespace furita
