#include "queries.hpp"
#include "furita/common/rule.hpp"

#include <sharpei_client/sharpei_client.h>
#include <pgg/factory.h>
#include <pgg/service/uid_resolver.h>

namespace furita {
namespace pq {
struct BWListHandler : boost::enable_shared_from_this<BWListHandler> {
    void HandleBWList(pgg::error_code ec, const std::vector<reflection::ListEntry>& res, promise<rules::blacklist_ptr> prom) {
        if (ec) {
            prom.set_exception(pgg::system_error(ec));
        } else {
            rules::blacklist_ptr bw_list_ptr = boost::make_shared<rules::blacklist>();
            for (auto& record : res) {
                rules::blacklist_entry bw_entry;
                bw_entry.created = record.created;
                bw_entry.email = record.email;
                switch (rules::ListType::fromString(record.list)) {
                    case rules::ListType::BLACK:
                        bw_list_ptr->black.insert(bw_entry);
                        break;
                    case rules::ListType::WHITE:
                        bw_list_ptr->white.insert(bw_entry);
                        break;
                    default:
                        prom.set_exception(yplatform::exception("error", "Unexpected list type: " + record.list));
                        return;
                }
            }
            prom.set(bw_list_ptr);
        }
    }
};
}
}
