#include "queries.hpp"
#include "furita/common/rule.hpp"
#include "furita/common/rule_helper.hpp"

#include <sharpei_client/sharpei_client.h>
#include <pgg/factory.h>
#include <pgg/service/uid_resolver.h>

namespace furita {
namespace pq {
struct EditRuleHandler : boost::enable_shared_from_this<EditRuleHandler> {
    std::vector<std::string> PrepareActions(const rules::action_list_ptr& action_list) {
        std::vector<std::string> acts;
        for (const auto& a : *action_list) {
            acts.push_back(a->oper);
            acts.push_back(a->param);
            acts.push_back(a->verified ? "t" : "f");
        }
        return acts;
    }

    std::vector<std::string> PrepareConditions(const rules::condition_list_ptr& condition_list) {
        std::vector<std::string> conds;
        for (const auto& c : *condition_list) {
            conds.push_back(rules_helpers::findFieldType(c->field));
            conds.push_back(c->field);
            conds.push_back(c->pattern);
            conds.push_back(c->oper.toString());
            conds.push_back(c->link.toString());
            conds.push_back(c->neg ? "t" : "f");
        }
        return conds;
    }
};

}
}
