#include "queries.hpp"
#include "furita/common/rule.hpp"

#include <sharpei_client/sharpei_client.h>
#include <pgg/factory.h>
#include <pgg/service/uid_resolver.h>

namespace furita {
namespace pq {
struct GetActionsHandler : boost::enable_shared_from_this<GetActionsHandler> {
    void HandleActions(pgg::error_code ec, const std::vector<reflection::Action>& res, promise<rules::action_list_ptr> prom) {
        if (ec) {
            prom.set_exception(pgg::system_error(ec));
        } else {
            rules::action_list_ptr action_list = boost::make_shared<rules::action_list>();
            for (const auto& record : res) {
                rules::action_ptr a = boost::make_shared<rules::action>();
                a->rule_id = record.rule_id;
                a->id = record.action_id;
                a->oper = record.oper;
                a->param = record.param;
                a->verified = record.verified;
                action_list->push_back(a);
            }
            prom.set(action_list);
        }
    }
};
}
}
