#include "queries.hpp"
#include "furita/common/rule.hpp"

#include <sharpei_client/sharpei_client.h>
#include <pgg/factory.h>
#include <pgg/service/uid_resolver.h>

namespace furita {
namespace pq {
struct GetConditionsHandler : boost::enable_shared_from_this<GetConditionsHandler> {
    void HandleConditions(pgg::error_code ec, const std::vector<reflection::Condition>& res, promise<rules::condition_list_ptr> prom) {
        if (ec) {
            prom.set_exception(pgg::system_error(ec));
        } else {
            rules::condition_list_ptr condition_list = boost::make_shared<rules::condition_list>();
            for (const auto& record : res) {
                rules::condition_ptr c = boost::make_shared<rules::condition>();
                c->rule_id = record.rule_id;
                c->field_type = record.field_type;
                c->field = record.field;
                c->pattern = record.pattern;
                c->oper = rules::condition::oper_type::fromString(record.oper);
                c->link = rules::condition::link_type::fromString(record.link);
                c->neg = record.negative;
                condition_list->push_back(c);
            }
            prom.set(condition_list);
        }
    }
};
}
}
